// Engine.h: interface for the Engine class.
//
//////////////////////////////////////////////////////////////////////
#include "Move.h"
#include "GeneratedMoves.h"

#if !defined(AFX_ENGINE_H__59B56213_0A1C_41C8_B274_86E23948F7F9__INCLUDED_)
#define AFX_ENGINE_H__59B56213_0A1C_41C8_B274_86E23948F7F9__INCLUDED_


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class Engine  
{

private:

	//Board representation
	int squarePiece[64], squareSide[64];
	int whiteKingSquare, blackKingSquare;
	int sideToMove, moveCount;

	//Array of precomputed directions indexed by square
	int columnUpMoves[64][8], columnDownMoves[64][8], rankRightMoves[64][8], rankLeftMoves[64][8], diagonal45Moves[64][8], diagonal135Moves[64][8], diagonal225Moves[64][8], diagonal315Moves[64][8], kingMoves[64][8], knightMoves[64][8];
	int columnNumbers[64], rankNumbers[64], squaresByColumn[64];

	//Arrays containing sliding directions for pieces of 1, 4 and 8 directions
	int oneDirection[8];
	int fourDirections[4][8];
	int eightDirections[8][8];

	void InitializeGlobalVariables();

	//Methods for generate precomputed sliding moves.
	void GenerateColumnUpMoves();
	void GenerateDiagonal45Moves();
	void GenerateRankRightMoves();
	void GenerateDiagonal135Moves();
	void GenerateColumnDownMoves();
	void GenerateDiagonal225Moves();
	void GenerateRankLeftMoves();
	void GenerateDiagonal315Moves();

	//Method for generate precomputed king moves
	void GenerateKingMoves();

	//Method for generate precomputed knight moves
	void GenerateKnightMoves();
	
	//This Method return the array of directions for piece and square
	void GenerateNoPawnDirections(int slidingPiece, int square);

	//Board initialization and move generation methods
	void InitializeBoard();
	void GenerateAllMoves();
	void GenerateAllCaptures();
	GeneratedMoves* GenerateAllSortedCaptures();
	void TestAndAddMove(int from, int to, int movingPiece, bool capture, int castleMoveCode);
	void AddToLegalPromoteMoveList(int from, int to, int movingPiece, int pieceToPromote);
	void AddToLegalPromoteAndCaptureMoveList(int from, int to, int movingPiece, int pieceToPromote);
	void AddToLegalCaptureMoveList(int from, int to, int movingPiece);
	void AddToLegalNonCaptureMoveList(int from, int to, int movingPiece, int castleMoveCode);

	//Move generation arrays and counters
	Move legalNonCapture[NON_CAPTURE_MOVE_COUNT], legalCapture[CAPTURE_MOVE_COUNT], 
		 legalPromote[PROMOTE_MOVE_COUNT], legalPromoteAndCapture[PROMOTE_AND_CAPTURE_MOVE_COUNT];
			 	
	int legalNonCaptureCount, legalCaptureCount, legalPromoteCount, legalPromoteAndCaptureCount;
	Move blankLegalNonCapture[NON_CAPTURE_MOVE_COUNT], blankLegalCapture[CAPTURE_MOVE_COUNT], 
		 blankLegalPromote[PROMOTE_MOVE_COUNT], blankLegalPromoteAndCapture[PROMOTE_AND_CAPTURE_MOVE_COUNT];
	
	//Methos used for move sorting
	static int MoveComparer(const void* a, const void* b);

	//Castle flag variables
	bool whiteKingCastled;
	bool blackKingCastled;
	
	//"The Brain" methods and variables
	int FindCheckMate(int sideToEval, int depth, int initialDepth, int alpha, int beta, Move* bestMove);
	int AlphaBetaNegamax(bool firstPass, int depth, int alpha, int beta, Move* bestMove);
	int Quiescent(int quiesDepht, int alpha, int beta);

	//Evaluate methods and variables.
	int Evaluate();
	int CountAttacks(int square, int attackerSide);
	int pieceValue[6];
	int isolatedPawnPenalty[8];
	int GetDistance(int square1, int square2);
	int GetXRayScore(int square, int piece, int sideOfPiece);
	bool BishopAttackSquare(int square, int attackerSquare);
	
	
	void TestAttacks(int square);
	int attackSquares[64], blankAttackSquares[64];
	bool InCheck(int side);
	bool IsSquareInAttack(int square, int sideOfSquare);

	
public:

	//Testing
	int Engine::TestReference(int d, Move* move);
	void Test();
	Move GetRandomMove();

	//"The Brain" most important method.
	Move GetBestMove(int depth);

	//Move methods
	GeneratedMoves* GenerateAllSortedMoves();
	void MakeMove(Move move);
	void TakeBackMove(Move move);

	int GameStatus;

	Engine();
	virtual ~Engine();

};

#endif // !defined(AFX_ENGINE_H__59B56213_0A1C_41C8_B274_86E23948F7F9__INCLUDED_)
